/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.compat.tlm.message;

import com.github.tartaricacid.netmusic.client.audio.MusicPlayManager;
import com.github.tartaricacid.netmusic.compat.tlm.chatbubble.LyricChatBubbleData;
import com.github.tartaricacid.netmusic.compat.tlm.client.audio.MaidNetMusicSound;
import com.github.tartaricacid.netmusic.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import io.netty.buffer.ByteBuf;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MaidMusicToClientMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<MaidMusicToClientMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"netmusic", (String)"maid_music_to_client"));
    public static final StreamCodec<ByteBuf, MaidMusicToClientMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, MaidMusicToClientMessage::getEntityId, (StreamCodec)ByteBufCodecs.STRING_UTF8, MaidMusicToClientMessage::getUrl, (StreamCodec)ByteBufCodecs.VAR_INT, MaidMusicToClientMessage::getTimeSecond, (StreamCodec)ByteBufCodecs.STRING_UTF8, MaidMusicToClientMessage::getSongName, MaidMusicToClientMessage::new);
    private static final Pattern PATTERN = Pattern.compile("^.*?\\?id=(\\d+)\\.mp3$");
    private final int entityId;
    private final String url;
    private final int timeSecond;
    private final String songName;

    public MaidMusicToClientMessage(int entityId, String url, int timeSecond, String songName) {
        this.entityId = entityId;
        this.url = url;
        this.timeSecond = timeSecond;
        this.songName = songName;
    }

    public static void showLyric(EntityMaid maid, String url, String songName, int timeSecond) {
        Matcher matcher;
        if (((Boolean)GeneralConfig.ENABLE_MAID_LYRICS.get()).booleanValue() && url.startsWith("https://music.163.com/") && (matcher = PATTERN.matcher(url)).find()) {
            long musicId = Long.parseLong(matcher.group(1));
            int songTimeTick = timeSecond * 20 + 20;
            long gameTime = maid.level().getGameTime();
            LyricChatBubbleData bubbleData = new LyricChatBubbleData(musicId, songName, songTimeTick, gameTime);
            maid.getChatBubbleManager().addChatBubble((IChatBubbleData)bubbleData);
        }
    }

    public static void handle(MaidMusicToClientMessage message, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> CompletableFuture.runAsync(() -> MaidMusicToClientMessage.onHandle(message), Util.backgroundExecutor()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(MaidMusicToClientMessage message) {
        if (Minecraft.getInstance().level == null) {
            return;
        }
        Entity entity = Minecraft.getInstance().level.getEntity(message.entityId);
        if (!(entity instanceof EntityMaid)) {
            return;
        }
        EntityMaid maid = (EntityMaid)entity;
        MusicPlayManager.play(message.url, message.songName, url -> new MaidNetMusicSound(maid, (URL)url, message.timeSecond));
    }

    public int getEntityId() {
        return this.entityId;
    }

    public String getUrl() {
        return this.url;
    }

    public int getTimeSecond() {
        return this.timeSecond;
    }

    public String getSongName() {
        return this.songName;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

